/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.Listing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.pokesplash.gts.Listing.ItemListing;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.Listing.PokemonListing;
import org.pokesplash.gts.api.provider.ListingAPI;
import org.pokesplash.gts.util.Deserializer;
import org.pokesplash.gts.util.Utils;

public class ListingsProvider {
    protected ArrayList<Listing> listings = new ArrayList();
    protected HashMap<UUID, ArrayList<Listing>> expiredListings = new HashMap();
    private final String brokenFilePath = "/config/gts/invalid/listings/";

    public void relistAllExpiredListings(UUID player) {
        ArrayList<Listing> expired = this.getExpiredListings().get(player);
        if (expired == null) {
            return;
        }
        if (ListingAPI.getHighestPriority() != null) {
            List<Listing> clonedList = expired.stream().map(Listing::deepClone).toList();
            for (Listing listing : clonedList) {
                listing.renewEndTime();
                ListingAPI.getHighestPriority().update(listing);
            }
            return;
        }
        for (Listing listing : expired) {
            listing.renewEndTime();
            this.addListing(listing);
        }
        this.delExpiredListing(player);
    }

    public List<Listing> getListings() {
        return this.listings;
    }

    public List<PokemonListing> getPokemonListings() {
        ArrayList<PokemonListing> pkmListings = new ArrayList<PokemonListing>();
        for (Listing listing : this.getListings()) {
            if (!(listing instanceof PokemonListing)) continue;
            pkmListings.add((PokemonListing)listing);
        }
        return pkmListings;
    }

    public List<Listing> getListingsByPlayer(UUID uuid) {
        ArrayList<Listing> playerListings = new ArrayList<Listing>();
        for (Listing listing : this.getListings()) {
            if (!listing.getSellerUuid().equals(uuid)) continue;
            playerListings.add(listing);
        }
        return playerListings;
    }

    public List<PokemonListing> getPokemonListingsByPlayer(UUID uuid) {
        ArrayList<PokemonListing> playerListings = new ArrayList<PokemonListing>();
        for (PokemonListing pokemonListing : this.getPokemonListings()) {
            if (!pokemonListing.getSellerUuid().equals(uuid)) continue;
            playerListings.add(pokemonListing);
        }
        return playerListings;
    }

    public List<ItemListing> getItemListings() {
        ArrayList<ItemListing> itemListings = new ArrayList<ItemListing>();
        for (Listing listing : this.getListings()) {
            if (!(listing instanceof ItemListing)) continue;
            itemListings.add((ItemListing)listing);
        }
        return itemListings;
    }

    public List<ItemListing> getItemListingsByPlayer(UUID uuid) {
        ArrayList<ItemListing> playerListings = new ArrayList<ItemListing>();
        for (ItemListing item : this.getItemListings()) {
            if (!item.getSellerUuid().equals(uuid)) continue;
            playerListings.add(item);
        }
        return playerListings;
    }

    public boolean addListing(Listing listing) throws IllegalArgumentException {
        if (this.hasListing(listing.getId(), this.getListings())) {
            throw new IllegalArgumentException("This listing already exists!");
        }
        this.putListing(listing);
        return listing.write("/config/gts/listings");
    }

    public boolean removeListing(Listing listing) throws IllegalArgumentException {
        if (!this.hasListing(listing.getId(), this.getListings())) {
            throw new IllegalArgumentException("No listing with the UUID " + String.valueOf(listing.getId()) + " exists.");
        }
        return this.delListing(listing);
    }

    private boolean hasListing(UUID id, List<Listing> listings) {
        for (Listing listing : listings) {
            if (!listing.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExpiredListings(UUID playerUUID) {
        return this.getExpiredListings().containsKey(playerUUID);
    }

    public boolean addExpiredListing(Listing listing) {
        if (this.getExpiredListings().containsKey(listing.getSellerUuid())) {
            ArrayList<Listing> currentListings = this.getExpiredListings().get(listing.getSellerUuid());
            if (!currentListings.contains(listing)) {
                currentListings.add(listing);
                this.putExpiredListing(listing.getSellerUuid(), currentListings);
            }
        } else {
            this.putExpiredListing(listing.getSellerUuid(), new ArrayList<Listing>(List.of(listing)));
        }
        return true;
    }

    public boolean removeExpiredListing(Listing listing) {
        if (this.getExpiredListings().get(listing.getSellerUuid()) == null) {
            return false;
        }
        ArrayList<Listing> listings = this.getExpiredListings().get(listing.getSellerUuid());
        if (listings.contains(listing)) {
            listings.remove(listing);
            this.putExpiredListing(listing.getSellerUuid(), listings);
            return true;
        }
        return false;
    }

    public Listing getActiveListingById(UUID id) {
        for (Listing listing : this.getListings()) {
            if (!listing.getId().equals(id)) continue;
            return listing;
        }
        return null;
    }

    public Listing getExpiredListingById(UUID id) {
        for (ArrayList<Listing> playerListings : this.getExpiredListings().values()) {
            for (Listing listing : playerListings) {
                if (!listing.getId().equals(id)) continue;
                return listing;
            }
        }
        return null;
    }

    public Listing getListingById(UUID id) {
        Listing activeListing = this.getActiveListingById(id);
        if (activeListing != null) {
            return activeListing;
        }
        return this.getExpiredListingById(id);
    }

    public List<Listing> getExpiredListingsOfPlayer(UUID player) {
        if (this.getExpiredListings().get(player) == null) {
            return Collections.emptyList();
        }
        return this.getExpiredListings().get(player);
    }

    public HashMap<UUID, ArrayList<Listing>> getExpiredListings() {
        return this.expiredListings;
    }

    public void check() {
        ArrayList<Listing> toRemove = new ArrayList<Listing>();
        for (Listing listing : this.getListings()) {
            if (listing.getEndTime() >= new Date().getTime() || listing.getEndTime() == -1L) continue;
            toRemove.add(listing);
        }
        for (Listing<Object> listing : toRemove) {
            boolean success = this.removeListing(listing);
            this.addExpiredListing(listing);
        }
    }

    protected boolean putListing(Listing listing) {
        return this.listings.add(listing);
    }

    protected boolean delListing(Listing listing) {
        return this.listings.remove(listing);
    }

    protected void putExpiredListing(UUID playerUUID, ArrayList<Listing> listings) {
        this.expiredListings.put(playerUUID, listings);
    }

    protected void delExpiredListing(UUID playerUUID) {
        this.expiredListings.remove(playerUUID);
    }

    public void init() {
        this.listings = new ArrayList();
        File dir = Utils.checkForDirectory("/config/gts/listings");
        String[] list = dir.list();
        if (list.length != 0) {
            for (String file : list) {
                Utils.readFileAsync("/config/gts/listings", file, el -> {
                    GsonBuilder builder = new GsonBuilder();
                    builder.registerTypeAdapter(Listing.class, (Object)new Deserializer(PokemonListing.class));
                    builder.registerTypeAdapter(Listing.class, (Object)new Deserializer(ItemListing.class));
                    Gson gson = builder.setPrettyPrinting().create();
                    Listing listing = (Listing)gson.fromJson(el, Listing.class);
                    Listing listing2 = listing = listing.isPokemon() ? (Listing)gson.fromJson(el, PokemonListing.class) : (Listing)gson.fromJson(el, ItemListing.class);
                    if (!listing.isListingValid()) {
                        System.out.println("[GTS] Invalid file: " + file + " has been removed.");
                        Utils.writeFileAsync("/config/gts/invalid/listings/", file, gson.toJson((Object)listing));
                        Utils.deleteFile("/config/gts/listings", file);
                        return;
                    }
                    if (!listing.getVersion().equals("2.0")) {
                        // empty if block
                    }
                    if (listing.getEndTime() > new Date().getTime() || listing.getEndTime() == -1L) {
                        this.putListing(listing);
                    } else {
                        this.addExpiredListing(listing);
                    }
                });
            }
        }
    }
}

